
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_InitTerminate.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "SST_TST.h"
#if TST_USE_INIT_TERMINATE_MODULE
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
/************* Private function prototype **********************/
/************************ Public Functions *********************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_InitTerminate         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *   Verify that init and terminate commands work
 *  
 * Algorithm:       
 *    1.  Terminate the SST operation by calling: SST_Terminate.
 *    2.  Initialize the SST again by calling: SST_Init.
 *    3.    Verify that aInitInfo indicates a new data base
 *    4.  Create a new session by calling: SST_SessionCreate.
 *    5.  Open a transaction by calling: SST_TransactionStart.
 *    6.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    7.  Close the transaction by calling: SST_TransactionEnd.
 *    8.  Delete the session by calling: SST_SessionDelete.
 *    9.  Terminate the SST operation by calling: SST_Terminate.
 *    10.  Initialize the SST again by calling: SST_Init.
 *    11.  Create a new session by calling: SST_SessionCreate.
 *    12.  Open the password authenticator by calling: SST_AuthenticationOpen.
 *    13.  Open a transaction by calling: SST_TransactionStart.
 *    14.  Insert a new data object by calling: SST_InsertData.
 *    15.  Close the transaction by calling: SST_TransactionEnd.
 *    16.  Delete the session by calling: SST_SessionDelete.
 *    17.  Terminate the SST operation by calling: SST_Terminate.
 *    18.   Verify that aInitInfo indicates an old data base
 *    19.  Initialize the SST again by calling: SST_Init.
 *    20.  Create a new session by calling: SST_SessionCreate.
 *    21.  Open the password authenticator by calling: SST_AuthenticationOpen.
 *    22.  Read and compare the inserted data by calling: SST_ReadData.
 *    23.  Delete the session by calling: SST_SessionDelete.
 *    24.  Terminate the SST operation by calling: SST_Terminate.
 *    25.  Initialize the SST again by calling: SST_Init.
 *    26.  Create a new session by calling: SST_SessionCreate.
 *    27.  Open the password authenticator by calling: SST_AuthenticationOpen.
 *    28.  Open a transaction by calling: SST_TransactionStart.
 *    29.  Modify the data from selected location by calling: SST_ModifyData.
 *    30.  Close the transaction by calling: SST_TransactionEnd.
 *    31.  Delete the session by calling: SST_SessionDelete.
 *    32.  Terminate the SST operation by calling: SST_Terminate.
 *    33.  Initialize the SST again by calling: SST_Init.
 *    34.  Create a new session by calling: SST_SessionCreate.
 *    35.  Open the password authenticator by calling: SST_AuthenticationOpen.
 *    36.  Read and compare the inserted data by calling: SST_ReadData.
 *    37.  Get Data Size and compare by calling: SST_DataSizeGet.
 *    38.  Delete the session by calling: SST_SessionDelete.
 *    39.  Terminate the SST operation by calling: SST_Terminate.
 *    40.  Initialize the SST again by calling: SST_Init.
 *    41.  Create a new session by calling: SST_SessionCreate.
 *    42.  Open the password authenticator by calling: SST_AuthenticationOpen.
 *    43.  Open a transaction by calling: SST_TransactionStart.
 *    44.  Delete the data object by calling: SST_DataDelete.
 *    45.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    46.  Close the transaction by calling: SST_TransactionEnd.
 *    47.  Delete the session by calling: SST_SessionDelete.
 *    48.  Terminate the SST operation by calling: SST_Terminate.
 *    49.  Initialize the SST again by calling: SST_Init.
 *                          
 ********************************************************************************/    
DxError_t SST_TST_ATP_InitTerminate ( void )
{
    /********* TST Variables Definitions ************/
    int                         TST_index,TST_HandleType;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_InitTerminate";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_AuthHandle,TST_DataHandle;
    SSTDataType_t               TST_SimpleData = TST_DATA_OBJECT;
    DxUint32_t                  TST_TempDataSize,TST_OutputDataSize;
    SSTHandle_t                 TST_AuthDefaultHandle;
    SSTInitInfo_t               aInitInfo;
    DxError_t                   TST_Status;
    /********* TST Variables initialization *********/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** SST_TST_ATP_InitTerminate Tests ********************* \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    TST_Status = TESTPASS;

    for (TST_HandleType = TST_INTERNAL_HANDLE ; TST_HandleType < TST_HANDLES_TYPES ; TST_HandleType++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_BasicDataOpObjectTests ; TST_index++) /*To run on all test vectors*/
        {
            if (TST_HandleType == TST_INTERNAL_HANDLE)
            {   
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
                TST_DataHandle.objId = SST_HANDLE_RANDOM_GENERATE;
            }
            else
            {
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using external handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId  = TST_TEST_DEFINED_HENDLE;
                TST_DataHandle.objId  = TST_TEST_DEFINED_HENDLE_1;
            }

            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_ATP_DataOpTestData[TST_index].TST_Name,"\n"));

            /* Terminate the SST */
            /*-------------------*/
            TST_Status = SST_Terminate();

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Terminate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);



        /*open files and get files handle*/
#ifndef DX_NVS_RAM

        TST_Status =DX_VOS_FClose(TST_MainDBFileHandle);
        if (TST_Status == DX_FAILURE)
        {
          DX_VOS_Printf("CANT CLOSE MAIN FILE \n");
          return TESTFAIL;
        }
        
        TST_Status = DX_VOS_FOpen(&TST_MainDBFileHandle,SST_DB_FILENAME ,"w+b");
        if (TST_Status == DX_FAILURE)
        {
          DX_VOS_Printf("CANT OPEN MAIN FILE \n");
          return TESTFAIL;
        }

        TST_Status =DX_VOS_FClose(TST_SecondaryDBFileHandle);
        if (TST_Status == DX_FAILURE)
        {
          DX_VOS_Printf("CANT CLOSE SECONDARY FILE \n");
          return TESTFAIL;
        }

        TST_Status = DX_VOS_FOpen(&TST_SecondaryDBFileHandle,SST_DB_FILENAME_SECOND ,"w+b");
        if (TST_Status == DX_FAILURE)
        {
          DX_VOS_Printf("CANT OPEN SECONDARY FILE \n");
          return TESTFAIL;
        }
#else
         DX_VOS_MemSetZero(TST_MainDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
         DX_VOS_MemSetZero(TST_SecondaryDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
          
#endif

            /* Init the SST again for operations */
            /*-----------------------------------*/
      TST_Status = SST_Init((DxNvsMemoryId_t)TST_MainDBFileHandle,
                   (DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                   &aInitInfo,
                   TST_Workspace,
                   TST_WorkspaceSizeInBytes);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Init",
                            TST_ATP_DataOpTestData[TST_index].TST_Name,
                            TST_MasterTestName);
  

         
       if(aInitInfo.newDatabase == DX_TRUE)
         TST_Status = TESTPASS; 
       else
         TST_Status = TESTFAIL;
 
       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Validation of new database",
                            TST_ATP_DataOpTestData[TST_index].TST_Name,
                            TST_MasterTestName);



            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new password authenticator */
            /*-------------------------------------*/
            TST_AuthDefaultHandle.objDigest = 0;
      TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
            TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                        TST_SessionId,
                                                        TST_ATP_DataOpTestData[TST_index].TST_Password,
                                                        TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                                        TST_ATP_DataOpTestData[TST_index].TST_MaxNumOfTrials,
                                                        TST_AuthDefaultHandle,
                                                        &TST_AuthHandle,
                                                        TST_Workspace,
                                                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Terminate the SST */
            /*-------------------*/
            TST_Status = SST_Terminate();

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Terminate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Init the SST again for operations */
            /*-----------------------------------*/
            TST_Status = SST_Init((DxNvsMemoryId_t)TST_MainDBFileHandle,
                 (DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                 &aInitInfo,
                 TST_Workspace,
                 TST_WorkspaceSizeInBytes);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Init",
                            TST_ATP_DataOpTestData[TST_index].TST_Name,
                            TST_MasterTestName);


       
         if(aInitInfo.newDatabase == DX_FALSE)
         TST_Status = TESTPASS; 
       else
         TST_Status = TESTFAIL;
 
         TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Validation of existing database",
                            TST_ATP_DataOpTestData[TST_index].TST_Name,
                            TST_MasterTestName);



            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);



            /* Open the password authentication */
            /*----------------------------------*/
            TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                               TST_AuthHandle,
                                               TST_ATP_DataOpTestData[TST_index].TST_Password,
                                               TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                               TST_NO_CHALLENGE,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen - Passeord",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);

      /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Insert a new Data object */
            /*--------------------------*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_DataOpTestData[TST_index].TST_Data,
                                       TST_ATP_DataOpTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Terminate the SST */
            /*-------------------*/
            TST_Status = SST_Terminate();

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Terminate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Init the SST again for operations */
            /*-----------------------------------*/
            TST_Status = SST_Init((DxNvsMemoryId_t)TST_MainDBFileHandle,
                 (DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                 DX_NULL,
                 TST_Workspace,
                 TST_WorkspaceSizeInBytes);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Init",
                            TST_ATP_DataOpTestData[TST_index].TST_Name,
                            TST_MasterTestName);



            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open the password authentication */
            /*----------------------------------*/
            TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                               TST_AuthHandle,
                                               TST_ATP_DataOpTestData[TST_index].TST_Password,
                                               TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                               TST_NO_CHALLENGE,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen - Passeord",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Read the data */
            /*---------------*/
            TST_TempDataSize = TST_ATP_DataOpTestData[TST_index].TST_DataSize;

            TST_Status = SST_DataRead(TST_SessionId,
                                     TST_DataHandle,
                                     TST_ATP_DataOpTestData[TST_index].TST_DataReadOffset,
                                     TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                                     &TST_TempDataSize,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Compare the retrieved data to the original */
      /*--------------------------------------------*/
         if(!DX_VOS_MemCmp(TST_ATP_DataOpTestData[TST_index].TST_Data,
                TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                TST_ATP_DataOpTestData[TST_index].TST_DataSize))
                              TST_Status = TESTPASS; /*Data Buffers are the same*/
                              else
                              TST_Status = TESTFAIL; /*Data Buffers are different*/

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Original data",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);




            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Terminate the SST */
            /*-------------------*/
            TST_Status = SST_Terminate();

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Terminate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Init the SST again for operations */
            /*-----------------------------------*/
            TST_Status = SST_Init((DxNvsMemoryId_t)TST_MainDBFileHandle,
                 (DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                 DX_NULL,
                 TST_Workspace,
                 TST_WorkspaceSizeInBytes);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Init",
                            TST_ATP_DataOpTestData[TST_index].TST_Name,
                            TST_MasterTestName);



            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open the password authentication */
            /*----------------------------------*/
            TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                               TST_AuthHandle,
                                               TST_ATP_DataOpTestData[TST_index].TST_Password,
                                               TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                               TST_NO_CHALLENGE,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen - Passeord",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            
      /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Modify the data from selected location */
            /*----------------------------------------*/
            TST_Status = SST_DataModify(TST_TransactionId,
                                       TST_SessionId,                           
                                       TST_DataHandle,  
                                       TST_ATP_DataOpTestData[TST_index].TST_DataToWrite,
                                       TST_ATP_DataOpTestData[TST_index].TST_DataToWriteSize,
                                       TST_ATP_DataOpTestData[TST_index].TST_DataToWriteOffset,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataModify",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Terminate the SST */
            /*-------------------*/
            TST_Status = SST_Terminate();

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Terminate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Init the SST again for operations */
            /*-----------------------------------*/
            TST_Status = SST_Init((DxNvsMemoryId_t)TST_MainDBFileHandle,
                 (DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                 DX_NULL,
                 TST_Workspace,
                 TST_WorkspaceSizeInBytes);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Init",
                            TST_ATP_DataOpTestData[TST_index].TST_Name,
                            TST_MasterTestName);


            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open the password authentication */
            /*----------------------------------*/
            TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                               TST_AuthHandle,
                                               TST_ATP_DataOpTestData[TST_index].TST_Password,
                                               TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                               TST_NO_CHALLENGE,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen - Passeord",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Read the data */
            /*---------------*/
            TST_TempDataSize = TST_ATP_DataOpTestData[TST_index].TST_DataSize;

            TST_Status = SST_DataRead(TST_SessionId,
                                     TST_DataHandle,
                                     TST_ZERO,
                                     TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                                     &TST_TempDataSize,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Compare the retrieved data to the original */
      /*--------------------------------------------*/
         if(!DX_VOS_MemCmp(TST_ATP_DataOpTestData[TST_index].TST_ModifedData,
                TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                TST_ATP_DataOpTestData[TST_index].TST_DataSize))
                              TST_Status = TESTPASS; /*Data Buffers are the same*/
                              else
                              TST_Status = TESTFAIL; /*Data Buffers are different*/

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Modified data",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Get Data Size and compare */
            /*---------------------------*/
      TST_Status = SST_DataSizeGet(TST_SessionId,  
                                        TST_DataHandle,
                                        &TST_OutputDataSize,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataSizeGet",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);

             
            /* Compare retrieved data size to original */
            /*-----------------------------------------*/
         if(!DX_VOS_MemCmp(&TST_OutputDataSize,
                &TST_ATP_DataOpTestData[TST_index].TST_DataSize,
                sizeof(TST_OutputDataSize)))
                              TST_Status = TESTPASS; /*Data Buffers are the same*/
                              else
                              TST_Status = TESTFAIL; /*Data Buffers are different*/

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - data size",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Terminate the SST */
            /*-------------------*/
            TST_Status = SST_Terminate();

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Terminate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Init the SST again for operations */
            /*-----------------------------------*/
            TST_Status = SST_Init((DxNvsMemoryId_t)TST_MainDBFileHandle,
                 (DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                 DX_NULL,
                 TST_Workspace,
                 TST_WorkspaceSizeInBytes);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Init",
                            TST_ATP_DataOpTestData[TST_index].TST_Name,
                            TST_MasterTestName);



            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open the password authentication */
            /*----------------------------------*/
            TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                               TST_AuthHandle,
                                               TST_ATP_DataOpTestData[TST_index].TST_Password,
                                               TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                               TST_NO_CHALLENGE,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen - Passeord",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);



            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the data */
            /*-----------------*/
             TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the authenticator */
            /*--------------------------*/
            TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                                TST_AuthHandle);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete - Master authenticator",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Terminate the SST */
            /*-------------------*/
            TST_Status = SST_Terminate();

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Terminate",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Init the SST again for operations */
            /*-----------------------------------*/
            TST_Status = SST_Init((DxNvsMemoryId_t)TST_MainDBFileHandle,
                 (DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                 DX_NULL,
                 TST_Workspace,
                 TST_WorkspaceSizeInBytes);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_Init",
                            TST_ATP_DataOpTestData[TST_index].TST_Name,
                            TST_MasterTestName);

        }/*End of TST_index "for loop" */
    }/*End of TST_HandleType "for loop" */
    return TST_Status;

  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }
}/* End of SST_TST_ATP_BasicDataOp */

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

#endif
